CREATE TABLE Empresas_Sedes_Sec_Recursos (       
	Id_Recurso INT IDENTITY(1,1) NOT NULL,
	Id_Sector SMALLINT,
	Descripcion VARCHAR(255),
	Flag_Turnos	TINYINT,
	Activo	TINYINT,
 CONSTRAINT PK_ESSR_PorId PRIMARY KEY CLUSTERED ( Id_Recurso ASC )
) 
GO

CREATE INDEX IX_ESSR_PorSector ON Empresas_Sedes_Sec_Recursos (Id_Sector)


ALTER TABLE Empresas_Sedes_Sec_Recursos ADD CONSTRAINT FK_ESSR_Sectores FOREIGN KEY ( Id_Sector)
	REFERENCES Empresas_Sedes_Sectores (Id_Sector)

GO

------------------------------------------------------------------------
ALTER TABLE Empresas_Sedes ADD Flag_Turnos TINYINT
GO

ALTER TABLE Empresas_Sedes ADD Icono IMAGE
GO

ALTER TABLE Empresas_Sedes_Sectores ADD Flag_Turnos TINYINT
GO

ALTER TABLE Empresas_Sedes_Sectores ADD Icono IMAGE
GO

ALTER TABLE Empresas_Sedes_Sectores ADD Emails VARCHAR(3000) 
GO


--------------------------------------------------------
CREATE TABLE Empresas_Sedes_Sec_Recuros_Horarios (
	Id_Recurso_Horario INT IDENTITY(1,1) NOT NULL,
	Id_Recurso INT,
	Descripcion VARCHAR(255) NULL,
	Frecuencia INT NULL,
	Dias_Futuro SMALLINT NULL,
	Minutos_Anticipacion INT NULL,
	Hora_Inicio DATETIME NULL,
	Hora_Fin DATETIME NULL,
	Activo TINYINT NULL,
	Lunes TINYINT NULL,
	Martes TINYINT NULL,
	Miercoles TINYINT NULL,
	Jueves TINYINT NULL,
	Viernes TINYINT NULL,
	Sabado TINYINT NULL,
	Domingo TINYINT NULL,
	Cupo_Max_Indiv INT NULL,
	Cupo_Max_Compartido INT NULL,
	Id_Producto VARCHAR(14) NULL,
	Id_Tipo_Cbte CHAR(4) NULL,
 CONSTRAINT PK_ESSRH_PorId PRIMARY KEY CLUSTERED (Id_Recurso_Horario ASC )
)

GO


ALTER TABLE Empresas_Sedes_Sec_Recuros_Horarios  ADD  CONSTRAINT FK_ESSRH_Recurdos FOREIGN KEY(Id_Recurso)
	REFERENCES Empresas_Sedes_Sec_Recursos (Id_Recurso)
GO


ALTER TABLE Empresas_Sedes_Sec_Recuros_Horarios ADD  CONSTRAINT FK_ESSRH_Cbtes_Tipos FOREIGN KEY(Id_Tipo_Cbte)
	REFERENCES Cbtes_Tipos (Id_Tipo_Cbte)
GO

ALTER TABLE Empresas_Sedes_Sec_Recuros_Horarios ADD  CONSTRAINT FK_ESSRH_Productos FOREIGN KEY(Id_Producto)
	REFERENCES Productos (Id_Producto)
GO

-------------------------------------------------------------------------

CREATE TABLE Empresas_Sedes_Sec_Recuros_Bloqueos(
	Id_Recurso_Bloq INT IDENTITY(1,1) NOT NULL,
	Id_Recurso INT,
    Descripcion	VARCHAR(255),
	Hora_Inicio DATETIME NULL,
	Hora_Fin DATETIME NULL,
	Lunes TINYINT NULL,
	Martes TINYINT NULL,
	Miercoles TINYINT NULL,
	Jueves TINYINT NULL,
	Viernes TINYINT NULL,
	Sabado TINYINT NULL,
	Domingo TINYINT NULL,
	Activo	TINYINT,
 CONSTRAINT PK_ESSRB_PorId PRIMARY KEY CLUSTERED ( Id_Recurso_Bloq ASC )
) 
GO

CREATE INDEX IX_ESSRB_PorRecur ON Empresas_Sedes_Sec_Recuros_Bloqueos (Id_Recurso)

ALTER TABLE Empresas_Sedes_Sec_Recuros_Bloqueos ADD CONSTRAINT FK_ESSRB_Recursos FOREIGN KEY ( Id_Recurso )
	REFERENCES Empresas_Sedes_Sec_Recursos (Id_Recurso)



----------------------------------------------------------------------

CREATE TABLE Empresas_Sedes_Sectores_Prod(
	Id_Sector_Prod INT IDENTITY(1,1) NOT NULL,
	Id_Sector SMALLINT,
    Id_Producto	VARCHAR(14) NOT NULL,
	Activo	TINYINT,
 CONSTRAINT PK_ESSP_PorId PRIMARY KEY CLUSTERED (	Id_Sector_Prod ASC )
) 
GO

CREATE INDEX IX_ESSP_PorSector ON Empresas_Sedes_Sectores_Prod (Id_Sector_Prod)
CREATE INDEX IX_ESSP_PorProd  ON Empresas_Sedes_Sectores_Prod (Id_Producto)

ALTER TABLE Empresas_Sedes_Sectores_Prod ADD CONSTRAINT FK_ESSP_Sector FOREIGN KEY (Id_Sector )
	REFERENCES Empresas_Sedes_Sectores (Id_Sector )


ALTER TABLE Empresas_Sedes_Sectores_Prod ADD CONSTRAINT FK_ESSP_Prod FOREIGN KEY ( Id_Producto )
	REFERENCES Productos (Id_Producto)

-----------------------------------------------------------------------------------------

CREATE TABLE Empresas_Sedes_Sectores_Venc(
	Id_Sector_Venc INT IDENTITY(1,1) NOT NULL,
	Id_Sector SMALLINT,
	Id_Tipo_Venc VARCHAR(10),
	Activo	TINYINT,
 CONSTRAINT PK_ESSV_PorId PRIMARY KEY CLUSTERED (	Id_Sector_Venc ASC )
) 
GO

CREATE INDEX IX_ESSV_PorSector ON Empresas_Sedes_Sectores_Venc (Id_Sector)
CREATE INDEX IX_ESSV_PorVenc  ON Empresas_Sedes_Sectores_Venc (Id_Tipo_Venc)

ALTER TABLE Empresas_Sedes_Sectores_Venc ADD CONSTRAINT FK_ESSV_Sector FOREIGN KEY (Id_Sector)
	REFERENCES Empresas_Sedes_Sectores (Id_Sector)

ALTER TABLE Empresas_Sedes_Sectores_Venc ADD CONSTRAINT FK_ESSV_Venc FOREIGN KEY ( Id_Tipo_Venc )
	REFERENCES Clientes_Venc_Tipos (Id_Tipo_Venc)




-------------------------------------------------------------------------

DROP TABLE CRM_Turnos_Tipos_G_Prod
DROP TABLE CRM_Turnos_Tipos_G_Venc
DROP TABLE CRM_Turnos_Tipos_Bloqueos
DROP TABLE CRM_Turnos
DROP TABLE CRM_Turnos_Tipos
DROP TABLE CRM_Turnos_Tipos_Grupos


--------------------------------------------------------------------------------

CREATE TABLE dbo.CRM_Turnos(
	Id_Turno BIGINT IDENTITY(1,1) NOT NULL,
	Id_Usuario SMALLINT NULL,
	Id_Cliente INT NULL,
	Id_Recurso INT NULL,
	Fecha DATETIME NULL,
	Descripcion VARCHAR(255) NULL,
	Estado CHAR(1) NULL,
 CONSTRAINT PK_CTur_PorId PRIMARY KEY CLUSTERED ( Id_Turno ASC )
)

GO


ALTER TABLE CRM_Turnos  ADD  CONSTRAINT FK_CTur_Clientes FOREIGN KEY(Id_Cliente)
REFERENCES Clientes (Id_Cliente)
GO

ALTER TABLE CRM_Turnos  ADD  CONSTRAINT FK_CTur_Seg_User FOREIGN KEY(Id_Usuario)
REFERENCES Seg_User (No)
GO


ALTER TABLE dbo.CRM_Turnos ADD  CONSTRAINT FK_CTur_Recursos FOREIGN KEY(Id_Recurso)
REFERENCES  Empresas_Sedes_Sec_Recursos (Id_Recurso)
GO








